import io
import os
import re
from setuptools import setup, find_packages

here = os.path.abspath(os.path.dirname(__file__))
with io.open(os.path.join(here, 'README.md'), encoding='utf-8') as f:
    long_description = '\n' + f.read()


def get_version():
    with open('py_odoo/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of py_odoo")

        version = match.group(1)
        return version


setup(
    name='py_odoo',
    version=get_version(),
    description="Python wrapper for Odoo REST API",
    long_description=long_description,
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    packages=find_packages(exclude=["tests"]),
    package_dir={'': '.'},
    license='MIT',
    zip_safe=True,
    url='https://code.compassfoundation.io/odoo/pyodoo',
    include_package_data=True,
    install_requires=[
        'lcconfig',
        'lcrequests',
    ],
    classifiers=[
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'Operating System :: OS Independent',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
        'Programming Language :: Python :: Implementation :: CPython',
    ],
)
