from typing import Literal, TypedDict

RedwoodAction = Literal['allow', 'block', 'ignore', 'block-invisible', 'classify', 'ssl-bump']


class AccessLogData(TypedDict):
    """
    Dictionary generated by csv.DictReader
    that parses Redwood access.log lines.
    """

    ldate: str
    user: str
    action: RedwoodAction
    url: str
    method: str | int
    status: str | int
    content_type: str
    content_length: str | int
    modified: str | bool
    tally: str
    scores: str
    conditions: str
    page_title: str | None
    ignored: str
    user_agent: str | None
    protocol: str
    referer: str
    platform: str
    header_filename: str
    virus: str
    rule_description: str
    origin_ip: str
    starlark_data: str


class AccessLogWsData(TypedDict):
    """
    Access Log Data for Websocket Server.
    """

    userip: str
    action: RedwoodAction
    line: str
    pk: str
    record: str


class TlsLogData(TypedDict):
    """
    Dictionary generated by csv.DictReader
    that parses Redwood tls.log lines.
    """

    date: str
    user: str
    serverAddr: str
    serverName: str
    err: str
    cachedCert: str
    tlsFingerprint: str


class TlsLogWsData(TypedDict):
    """
    TLS Log Data for Websocket Server.
    """

    server: str
    userip: str
    line: str
