import csv
import logging

logger = logging.getLogger(__name__)


# ----------------------------------------------------------------------
def flexi_csv_reader(csv_reader):
    """
    Skip to next line when encountering a CSV error
    instead of blowing up. Log Lines aren't that
    important; keep moving.
    """
    lines = []

    for line in csv_reader:
        try:
            lines.append(line)
        except csv.Error:
            logger.error(f'Malformed line: {line}')
            continue

    return lines


# ----------------------------------------------------------------------
def flexi_csv_generator(csv_reader):
    """
    Skip to next line when encountering a CSV error
    instead of blowing up. Log Lines aren't that
    important; keep moving.
    """
    while True:
        try:
            yield next(csv_reader)
        except csv.Error:
            # log the problem or whatever
            print("Problem with some row")
            continue


__all__ = [
    'flexi_csv_reader',
    'flexi_csv_generator',
]
