import logging
from ..typehints import AccessLogData

logger = logging.getLogger(__name__)


# ---------------------------------------------------------------
def skip_malformed(line_data: AccessLogData) -> bool:
    """Check for malformed lines"""
    try:
        if line_data['action'] == 'allow':
            # Something went wrong (status=0).
            # Blocked lines have status == 0, so only match when action == 'allow'
            if line_data['status'] == '0':
                return True

            # By all rights one expects content (content_length=0):
            # Page was allowed, and status 200, but nothing delivered
            # CONNECT requests are initially length 0, but then logged with
            # content length again when session completes, so save that line.
            if line_data['status'] == '200' and line_data['content_length'] == '0':
                return True
    except KeyError:
        logger.error(f'Could not process {line_data}')
        return True

    return False


__all__ = [
    'skip_malformed',
]
