import logging

logger = logging.getLogger(__name__)


# ---------------------------------------------------------------
def format_dns_logline(line: str) -> str:
    """
    Format lines of interest as CSV.
    """
    try:
        space_idx = line.index(' ')
        date = line[:space_idx]
        data_idx = line.index(': ', space_idx) + 2
        line_data = line[data_idx:]
    except (IndexError, ValueError) as e:
        logger.exception(f'DNS Log line error: {e}')
        return ''

    if line_data.startswith(('preresolve', 'postresolve')):
        return f'{date},{line_data}'

    return ''


__all__ = [
    'format_dns_logline',
]
