from .base import LogTailerObserver
from logtailer.handlers import RedwoodAccessHandler, RedwoodErrorsHandler, RedwoodTLSHandler


class RedwoodAccessObserver(LogTailerObserver):
    """
    Tail Redwood Access log
    """

    def __init__(self, ws_client):
        super().__init__(handler=RedwoodAccessHandler(ws_client))


class RedwoodErrorsObserver(LogTailerObserver):
    """
    Tail Redwood Errors log
    """

    def __init__(self, ws_client):
        super().__init__(handler=RedwoodErrorsHandler(ws_client))


class RedwoodTLSObserver(LogTailerObserver):
    """
    Tail Redwood TLS Log
    """

    def __init__(self, ws_client):
        super().__init__(handler=RedwoodTLSHandler(ws_client))


__all__ = (
    'RedwoodAccessObserver',
    'RedwoodErrorsObserver',
    'RedwoodTLSObserver',
)
