from .base import LogTailerObserver
from ..mixins import PDNSRecursorMixin
from logtailer.handlers import PDNSRecursorHandler


class PDNSRecursorObserver(PDNSRecursorMixin, LogTailerObserver):
    """
    Tail PDNS Recursor resolution logs
    """

    def __init__(self, ws_client):
        super().__init__(handler=PDNSRecursorHandler(ws_client))


__all__ = [
    'PDNSRecursorObserver',
]
