from typing import TYPE_CHECKING
from ..persistence import PersistDNSLogs
from ..settings import DNS_LOGLINE_FIELDS  # type: ignore[attr-defined]
from ..parsers import format_dns_logline
from ..settings import FILTER_SERVER

if TYPE_CHECKING:
    from ..handlers.base import LogTailerHandler

    MixinBase = LogTailerHandler
else:
    MixinBase = object


class PDNSRecursorMixin(MixinBase):
    """
    Tail PDNS Recursor resolution logs
    """

    name = 'dns_recursor'
    ws_channel = ''
    offset_file = '/var/tmp/dns_recursor.offset'
    watch_file = '/var/log/pdns_recursor.log'
    persist_class = PersistDNSLogs
    csv_fields = DNS_LOGLINE_FIELDS

    def as_data(self, line: str) -> dict:
        """
        If line is of interest, format it
        so it can be parsed by csv library.
        """
        if not FILTER_SERVER:
            return {}

        formatted = format_dns_logline(line)
        if not formatted:
            return {}

        return super().as_data(formatted)
