from pathlib import PosixPath


# --------------------------------------------------------------------------------
def get_database_service_name() -> str:
    """
    Various versions of Postgres will be installed on, so
    get postgres database name so service can be restarted
    """
    for dir_path in ('/usr/lib/systemd/system/', '/etc/init.d/'):
        path = PosixPath(dir_path)
        if not path.exists():
            continue

        try:
            installed_versions = sorted(path.glob('postgresql*'), reverse=True)
            script = installed_versions[0]
        except IndexError:
            continue

        # Trim off the .service / .sh extension
        if script.name.endswith(('.sh', 'service')):
            return '.'.join(script.name.split('.')[:-1])
        return script.name

    print('Unable to retrieve database service name')
    return ''
