from dataclasses import dataclass
from typing import Literal, TypedDict
from uuid import UUID

CanonicalID = str | UUID


@dataclass(frozen=True)
class KeyringService:
    LocalConsole: str = 'console'
    ImpersonatingConsole: str = 'impersonating'


class SyncPublisherData(TypedDict):
    url: str
    port: int
    mode: Literal['builtins', 'full', 'disabled']


class ConfigData(TypedDict):
    cid: str
    name: str
    is_active: bool
    rebranded: bool
    cloud_server: bool
    theme: str
    adminurl: str
    ddns_url: str
    device_dns_name: str
    external_port: int
    maincomp: str
    clarion_server: bool
    clarion_dns_name: str
    sync_role: str
    sync_publisher_data: SyncPublisherData
    fernet: str
    chacha: str

    # Remote Service Accounts
    garage_endpoint: str
    garage_region: str
    garage_key_id: str
    garage_key_secret: str
    email: str
    email_password: str

    # Branding settings
    slogan: str
    project_name: str
    filter_name: str
    console_name: str
    phone: str
    hostname: str
    support_email: str


class Impersonation(TypedDict):
    """
    Odoo will send a response back configuration data
    for the Impersonated and Impersonator systems.
    """

    impersonated: ConfigData
    impersonator: ConfigData
