from invoke import Context, task
from lcrequests import Request
from lcconfig import DynamicDNSConfig


def update_dns_target() -> str:
    """
    Call to DNS updater endpoint to update
    DNS Record to IP address of this machine
    """
    cfg = DynamicDNSConfig().as_typed_dict()
    url = cfg.get('url', '')

    if not url:
        return 'DNS Update URL not configured'

    try:
        req = Request(url=url)
        resp = req.get()
        if not resp.ok:
            return f'Request failed; returned status code {resp.status_code}.'
        return f'DNS record updated with current public IP. Request returned "{resp.text}".'
    except Exception as e:
        return f'Request failed with the error: {e}'


@task
def update_dns_name(ctx: Context):
    print(update_dns_target())
