# mypy: disable-error-code="arg-type"
from invoke import Collection
from . import classify
from . import console
from . import dns
from . import setup
from . import sys
from . import tls

try:
    from . import parser  # noqa

    load_parser = True
except (ModuleNotFoundError, ImportError):
    load_parser = False

ns = Collection()
ns.add_collection(classify)  # noqa
ns.add_collection(console)  # noqa
ns.add_collection(dns)  # noqa
if load_parser:
    ns.add_collection(parser)  # noqa
ns.add_collection(setup)  # noqa
ns.add_collection(sys)  # noqa
ns.add_collection(tls)  # noqa

# Add as tasks so that we can run them without
# specifying a namespace
ns.add_task(sys.health)  # noqa
ns.add_task(sys.restart)  # noqa
