from aspen_crypto.settings import LOCAL_VERIFICATION_KEY_FILE
from system_env import setup_portal_environment

PORTAL_ENV = setup_portal_environment()

EMAIL_SERVER_HOST = 'mail.drawbridge.systems'
EMAIL_SERVER_PORT = 587
CONF_DIR = PORTAL_ENV['CONF_DIR']
SYSTEM_CFG_BLOB_FILE = 'config_data.json'
CONSOLE_ROOT = PORTAL_ENV['ROOT_HOME']
CONSOLE_HOME = PORTAL_ENV['PROJECT_ROOT']
TLS_DIR = PORTAL_ENV['TLS_DIR']
VERIFICATION_KEY_FILE = f'{CONF_DIR}/{LOCAL_VERIFICATION_KEY_FILE}'
REDWOOD_CA_CERT_FILE = f'{TLS_DIR}/redwood_ca.pem'

IS_DRAWBRIDGE_OS = PORTAL_ENV['IS_DRAWBRIDGE_OS']
PORTAL_USER = 'portal' if IS_DRAWBRIDGE_OS else 'logcabin'
PORTAL_CODE_NAME = DATABASE_NAME = PORTAL_ENV['PORTAL_CODE_NAME']
PORTAL_LOG_DIR = f'/var/log/{PORTAL_CODE_NAME}/'
DB_HOST = '/var/run/postgresql' if IS_DRAWBRIDGE_OS else '/tmp'

PYTHON = '/usr/bin/python3.11' if IS_DRAWBRIDGE_OS else '/usr/bin/python3'

# Processes to enable / disable for various portal operations
DRAWBRIDGE_PROCESSES = 'hedge portal-server portal-cluster portal-beat redwood'
