from lcconfig import strtobool
import os

from invoke import Program, Collection
from invoke.config import Config, merge_dicts
from . import tasks
from . import __version__


class LogCabinConfig(Config):
    prefix = 'logcabin'

    @staticmethod
    def global_defaults():
        their_defaults = Config.global_defaults()
        # http://docs.pyinvoke.org/en/latest/concepts/configuration.html#environment-variables
        # feels like a hack that we shouldn't need, but setting the environment value
        # without defining config data here just doesn't work.
        my_defaults = {
            'run': {
                'echo': bool(strtobool(os.environ.get('INVOKE_RUN_ECHO', '0'))),
            },
        }
        return merge_dicts(their_defaults, my_defaults)


program = Program(
    version=__version__,
    config_class=LogCabinConfig,
    namespace=Collection.from_module(tasks),
)
