import os
from unittest import TestCase

from lcutils import LDAPServer


# -------------------------------------------------------------------------
class TestLDAPConfig(TestCase):

    @classmethod
    def setUpClass(cls) -> None:
        path = os.path.dirname(os.path.abspath(__file__))
        cls.ldap = LDAPServer()
        cls.ldap.config_settings = f'{path}/nslcd.conf'
        cls.ldap.load()

    def test_dynamic_attr(self):
        """
        Dynamically lookup values in file even if no
        property is defined on the class.
        """
        self.assertEqual(self.ldap.thisisavery, 'dynamicvalue')

    def test_values(self):

        for key, value in (
                ('uri', 'ldap://127.0.0.1/'),
                ('binddn', 'cn=manager,ou=Internal,dc=harrigan,dc=lan'),
                ('bindpw', 'ZFt8qVFRGGZCT'),
                ('bind_timelimit', '50'),
                ('search_scope', 'sub'),
                ('ldap_version', '3'),
        ):
            self.assertEqual(getattr(self.ldap, key), value)
