#!/usr/bin/python3

import io
from glob import glob
import re
from os.path import basename
from os.path import dirname
from os.path import join
from os.path import splitext

from setuptools import setup


def read(*names, **kwargs):
    return io.open(join(dirname(__file__), *names), encoding=kwargs.get('encoding', 'utf8')).read()


def get_version():
    with open('lcutils/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of lcutils")

        version = match.group(1)
        return version


setup(
    name='lcutils',
    version=get_version(),
    description='Utilities for the Log Cabin console and invoke commands on DrawBridge systems',
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    url='http://code.compassfoundation.io/dave/lcutils',
    packages=['lcutils'],
    py_modules=[splitext(basename(path))[0] for path in glob('src/*.py')],
    include_package_data=True,
    zip_safe=True,
    classifiers=[
        'Intended Audience :: Developers',
        'License :: SAP',
        'Operating System :: Unix',
        'Operating System :: POSIX',
        'Programming Language :: Python :: 3.11',
        'Programming Language :: Python :: 3.12',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
        'Topic :: Utilities',
    ],
    keywords=[
        'DrawBridge',
        'Log Cabin',
    ],
    install_requires=[
        'distro',
        'lcconfig',
        'lclazy',
        'psutil',
        'rules',
        'toml',
    ],
)
