from contextlib import suppress
import grp
import logging
import os
import pwd

logger = logging.getLogger(__name__)


# --------------------------------------------------------------------------
def set_pid_file(pidfile, group='logcabin', user='logcabin'):
    with open(pidfile, 'w') as pid:
        pid.write(str(os.getpid()))

    with suppress(KeyError):
        try:
            uid = pwd.getpwnam(user).pw_uid
            gid = grp.getgrnam(group).gr_gid

            os.chown(pidfile, uid, gid)
            os.chmod(pidfile, 0o777)
        except PermissionError:
            logger.error('Need elevated permission to change file ownership')


# --------------------------------------------------------------------------
def remove_pid_file(pidfile):
    try:
        os.remove(pidfile)
    except FileNotFoundError:
        logging.info(f'{pidfile} was already deleted')


__all__ = (
    'set_pid_file',
    'remove_pid_file',
)
