from rules import RuleSet


class LCRuleSet(RuleSet):

    def clone(self, app, new, base):
        """
        Helper function to quickly clone the permissions of one
        model to another. Useful for Proxy Models, for example.

        New and Base model must be in the same Django app
        """
        for action in ('add', 'change', 'list', 'view', 'delete'):
            target_model = f'{app}.{action}_{base}'
            try:
                self[f'{app}.{action}_{new}'] = self[target_model]
            except KeyError:
                pass


__all__ = [
    'LCRuleSet',
]
