import os
from subprocess import PIPE, Popen
import sys

# Some functions taken from # swiped from https://github.com/haiwen/seafile/blob/master/scripts/build/build-server.py
# For database setup, check https://github.com/haiwen/seafile/blob/master/scripts/setup-seafile-mysql.py


# ------------------------------------------------------------------------
def run_argv(argv, cwd=None, env=None, suppress_stdout=False, suppress_stderr=False) -> int:
    """
    Run a program and wait for it to finish, and return its exit code.
    The standard output of this program is suppressed.
    """
    with open(os.devnull, 'w') as devnull:
        if suppress_stdout:
            stdout = devnull
        else:
            stdout = sys.stdout

        if suppress_stderr:
            stderr = devnull
        else:
            stderr = sys.stderr

        proc = Popen(argv, cwd=cwd, stdout=stdout, stderr=stderr, env=env)
        return proc.wait()


# ------------------------------------------------------------------------
def run(cmdline, cwd=None, env=None, suppress_stdout=False, suppress_stderr=False) -> int:
    """Like run_argv but specify a command line string instead of argv"""
    with open(os.devnull, 'w') as devnull:
        if suppress_stdout:
            stdout = devnull
        else:
            stdout = sys.stdout

        if suppress_stderr:
            stderr = devnull
        else:
            stderr = sys.stderr

        proc = Popen(cmdline, cwd=cwd, stdout=stdout, stderr=stderr, env=env, shell=True)
        return proc.wait()


# ----------------------------------------------------------------------
def run_cmd(cmdline: str) -> str:
    """Run and get output of that command"""
    proc, err = Popen([cmdline], stdout=PIPE, stderr=PIPE, shell=True).communicate()
    if err:
        return err.decode().strip()
    return proc.decode().strip()


__all__ = (
    'run',
    'run_argv',
    'run_cmd',
)
