import re
import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()


def get_version():
    with open('lcrsync/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of lcrsync")

        version = match.group(1)
        return version


setuptools.setup(
    name="lcrsync",
    version=get_version(),
    author='Dave Burkholder',
    author_email='dave@thinkwelldesigns.com',
    description="Python module that wraps subprocess calls to rsync",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://code.compassfoundation.io/dave/lcrsync",
    packages=setuptools.find_packages(exclude=['tests']),
    platforms='any',
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>3.6'
)
