from typing import TypedDict


class RsyncInputs(TypedDict):
    cmd_list: list
    cmd_line: str
    cwd: str
    timeout: int


class RsyncResult(TypedDict):
    result: str
    cmd: str
    return_code: int
    stdout: str
    stderr: str
    inputs: RsyncInputs


class RsyncResultException(RsyncResult):
    type: str
    value: str
    traceback: Exception
