# Numerous consoles communicate with each other via API calls.
# These settings ensure that the required settings / records
# are created in the local database.

# Most clients will have this library installed, so variables
# are defined here, for use in various clients & consoles.
from dataclasses import dataclass
from typing import Union
from uuid import UUID
from .typehints import Subject


@dataclass(frozen=True)
class Company:
    cid: Union[UUID, str]
    name: str


@dataclass(frozen=True)
class User:
    cid: Union[UUID, str]
    username: str
    first_name: str
    last_name: str
    email: str


UMBRELLA_COMPANY = Company(
    cid='ece25487-20c2-6d6a-97ef-aceaee169a90',
    name='Umbrella API Communications',
)

ASPEN = User(
    first_name='Aspen',
    last_name='Umbrella',
    username='aspen_umbrella',
    cid='6143b927-0ed3-63d8-8624-9273b34a1592',
    email='aspen_umbrella@compassfoundation.io',
)

DRAWBRIDGE = User(
    first_name='DrawBridge',
    last_name='Umbrella',
    username='drawbridge_umbrella',
    cid='b41011e9-10c7-6df2-88ff-05789925fc7e',
    email='drawbridge_umbrella@compassfoundation.io',
)

BEACON = User(
    first_name='Beacon',
    last_name='Umbrella',
    username='beacon_umbrella',
    cid='f69cc837-b3c0-67f7-aca0-666d84d7c934',
    email='beacon_umbrella@compassfoundation.io',
)

CLARION = User(
    first_name='Clarion',
    last_name='Umbrella',
    username='clarion_umbrella',
    cid='b410e0c0-555a-6ca8-b94d-57f3d438b0ad',
    email='clarion_umbrella@compassfoundation.io',
)

CLAVIS = User(
    first_name='Clavis',
    last_name='Umbrella',
    username='clavis_umbrella',
    cid='61427510-c1f9-6dd5-bb6a-7209eeb71131',
    email='clavis_umbrella@compassfoundation.io',
)

DAYSTAR = User(
    first_name='Daystar',
    last_name='Umbrella',
    username='daystar_umbrella',
    cid='b4103cb2-2beb-6c33-9816-fb35f45a0a7e',
    email='daystar_umbrella@compassfoundation.io',
)

MAPLELEAF = User(
    first_name='MapleLeaf',
    last_name='Umbrella',
    username='mapleleaf_umbrella',
    cid='b4100ecf-1212-6702-9292-2d74896d7ade',
    email='mapleleaf_umbrella@compassfoundation.io',
)

ORBIT = User(
    first_name='Orbit',
    last_name='Umbrella',
    username='orbit_umbrella',
    cid='b410ef03-2abb-66c7-9d75-1336277ecef6',
    email='orbit_umbrella@compassfoundation.io',
)

VISION_MARKET = User(
    first_name='Vision Market',
    last_name='Umbrella',
    username='vision_market_umbrella',
    cid='61442ed3-a79a-6336-9f76-6c3a34c39226',
    email='vision_market_umbrella@compassfoundation.io',
)

CENTRAL = User(
    first_name='Umbrella',
    last_name='Central',
    username='umbrella_central',
    cid='feae4227-72de-6598-9ef7-129e8324aa11',
    email='umbrella_central@compassfoundation.io',
)

UMBRELLA_USERS: dict[str, User] = {
    Subject.Aspen: ASPEN,
    Subject.Clavis: CLAVIS,
    Subject.DrawBridge: DRAWBRIDGE,
    Subject.Beacon: BEACON,
    Subject.Clarion: CLARION,
    Subject.Daystar: DAYSTAR,
    Subject.MapleLeaf: MAPLELEAF,
    Subject.Orbit: ORBIT,
    Subject.VisionMarket: VISION_MARKET,
    Subject.Umbrella: CENTRAL,
}

# Records with these CIDs may not change!!
UMBRELLA_RESERVED_CIDS = {u.cid for u in UMBRELLA_USERS.values()}
UMBRELLA_SUBJECT_CODES_BY_USER = {user.cid: code for code, user in UMBRELLA_USERS.items()}

# A request with one of these Subjects
# in the payload pertains to Devices.
DEVICE_SUBJECTS = {
    Subject.Beacon.value,
    Subject.MapleLeaf.value,
    Subject.Orbit.value,
}

# A request with one of these Users
# in the payload may access Device CIDs.
DEVICE_UMBRELLA_USERS = {
    BEACON.cid,
    MAPLELEAF.cid,
    ORBIT.cid,
}
