from typing import Literal
from uuid import UUID

try:
    from enum import StrEnum
except (ModuleNotFoundError, ImportError):
    from strenum import StrEnum  # type: ignore[no-redef]

try:
    from typing import NotRequired, TypedDict
except (ImportError, ModuleNotFoundError):
    from typing_extensions import NotRequired, TypedDict

CID_STR = UUID | str
HTTP_VERBS = Literal['DELETE', 'GET', 'HEAD', 'OPTIONS', 'PATCH', 'POST', 'PUT', 'TRACE']


class Subject(StrEnum):
    """
    The subject should indicate the project
    for which this token is used. This is
    to provide an element of security to
    help prevent any compromised key from
    being used to gain broader API access.
    """

    Any = ''

    # company projects
    Aspen = 'aspen'
    Beacon = 'beacon'
    Clavis = 'clavis'
    Clarion = 'clarion'
    DrawBridge = 'drawbridge'
    Daystar = 'daystar'
    MapleLeaf = 'mapleleaf'
    Orbit = 'orbit'
    VisionMarket = 'market'

    # company infrastructure
    Umbrella = 'umbrella'
    Desk = 'desk'


class PasetoFooter(TypedDict):
    """
    The footer is primarily used to
    identify the Verification Key that
    should be used to verify the token.
    """

    cid: NotRequired[CID_STR]
    kid: NotRequired[str]


class PasetoPayload(TypedDict):
    """
    Payload with various registered claims
    plus a few custom claim names.
    """

    nonce: str
    exp: str
    nbf: str
    iat: NotRequired[str]
    iss: NotRequired[str]
    aud: NotRequired[str]

    # custom claim names
    email: NotRequired[str]
    user_cid: NotRequired[CID_STR]
    sub: NotRequired[Subject]
    sub_cid: NotRequired[CID_STR]
