# convenience imports so we don't need to import the
# urllib3 package in apps that use this library
from urllib3.exceptions import (  # noqa
    HTTPError,
    HTTPWarning,
    PoolError,
    RequestError,
    SSLError,
    ProxyError,
    DecodeError,
    ProtocolError,
    MaxRetryError,
    HostChangedError,
    TimeoutStateError,
    TimeoutError,
    ReadTimeoutError,
    ConnectTimeoutError,
    NewConnectionError,
    EmptyPoolError,
    ClosedPoolError,
    LocationValueError,
    LocationParseError,
    ResponseError,
    SecurityWarning,
    InsecureRequestWarning,
    SystemTimeWarning,
    InsecurePlatformWarning,
    DependencyWarning,
    ResponseNotChunked,
    BodyNotHttplibCompatible,
    IncompleteRead,
    InvalidHeader,
    ProxySchemeUnknown,
    HeaderParsingError,
    UnrewindableBodyError,
)


class LCHTTPError(HTTPError):
    """There was an ambiguous exception that occurred while handling your
    request.
    """

    def __init__(self, *args, **kwargs):  # noqa
        """Initialize RequestException with `response` object."""
        self.response = kwargs.pop('response', None)
        super().__init__()


class AuthenticationError(LCHTTPError):
    """Invalid authentication credentials"""


class AuthorizationError(LCHTTPError):
    """Invalid permission levels"""


class ClientError(LCHTTPError):
    """Client made an invalid request"""


class ServerError(LCHTTPError):
    """The Server encountered an error while processing the request"""
