"""
Extracted from django.utils.regex_helper for use in short scripts
without requiring a Django dependency.
"""
import re
from .functional import SimpleLazyObject


def lazy_re_compile(regex, flags=0):
    """Lazily compile a regex with flags."""

    def _compile():
        # Compile the regex if it was not passed pre-compiled.
        if isinstance(regex, (str, bytes)):
            return re.compile(regex, flags)
        else:
            assert not flags, 'flags must be empty if regex is passed pre-compiled'
            return regex

    return SimpleLazyObject(_compile)


__all__ = [
    'lazy_re_compile',
]
