#!/usr/bin/python3

import io
from glob import glob
import re
from os.path import basename
from os.path import dirname
from os.path import join
from os.path import splitext

from setuptools import setup


def read(*names, **kwargs):
    return io.open(join(dirname(__file__), *names), encoding=kwargs.get('encoding', 'utf8')).read()


def get_version():
    with open('lclazy/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of lclazy")

        version = match.group(1)
        return version


setup(
    name='lclazy',
    version=get_version(),
    description='Log Cabin Lazy Load Tools for quicker script loading time',
    long_description_content_type='text/markdown',
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    url='http://code.compassfoundation.io/dave/lclazy',
    packages=['lclazy'],
    py_modules=[splitext(basename(path))[0] for path in glob('src/*.py')],
    include_package_data=True,
    zip_safe=True,
    classifiers=[
        'Intended Audience :: Developers',
        'License :: MIT',
        'Operating System :: Unix',
        'Operating System :: POSIX',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
        'Topic :: Utilities',
    ],
    keywords=[
        'DrawBridge',
        'Log Cabin',
    ],
    install_requires=[
        'regex',
    ],
)
