try:
    import simdjson as _json
except ImportError:
    import json as _json
from .common import clean_byte_string, json_default_vals


def simdjson_dumps(
    data,
    indent=None,
    default=None,
    sort_keys=False,
    rtype='bytes',
) -> bytes | str:
    """
    Wrapper function for dumping python values to JSON,
    to make it easy to swap out JSON library project-wide.
    """
    value = _json.dumps(data, default=default or json_default_vals)
    if rtype == 'bytes':
        return value.encode('utf8')

    return value


def simdjson_loads(value: bytes | str):
    """
    Wrapper function for loading string to python values,
    for consistent value parsing and to make it easy to
    swap out JSON library project-wide.
    """
    try:
        return _json.loads(value)
    except Exception as e:
        try:
            return _json.loads(clean_byte_string(value))
        except Exception:
            pass

        raise e


__all__ = (
    'simdjson_loads',
    'simdjson_dumps',
)
