#!/usr/bin/python3

import io
import re

from os.path import dirname
from os.path import join

from setuptools import Extension, setup, find_packages

try:
    from Cython.Build import cythonize

    extensions = [
        Extension(
            name='lchttp.cyutil',
            sources=['lchttp/cyutil/uri.pyx'],
            compiler_directives={'language_level': 3},
        ),
    ]
except (ImportError, ModuleNotFoundError):
    extensions = []


def get_version():
    with open('lchttp/__init__.py', 'r') as f:
        line = f.readline()
        match = re.match(r'__version__ = \'([\d\.]+)\'', line)

        if not match:
            raise ImportError("Can't read the version of lchttp")

        version = match.group(1)
        return version


def read(*names, **kwargs):
    return io.open(
        join(dirname(__file__), *names),
        encoding=kwargs.get('encoding', 'utf8'),
    ).read()


setup_kwargs = dict(
    name='lchttp',
    version=get_version(),
    description='Log Cabin HTTP Tools',
    author='Dave Burkholder',
    author_email='dave@compassfoundation.io',
    url='http://code.compassfoundation.io/dave/lchttp',
    packages=find_packages(exclude=["tests"]),
    include_package_data=True,
    zip_safe=False,
    classifiers=[
        'Intended Audience :: Developers',
        'License :: SAP',
        'Operating System :: Unix',
        'Operating System :: POSIX',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
        'Topic :: Utilities',
    ],
    keywords=[
        'DrawBridge',
        'Log Cabin',
    ],
    install_requires=[
        'lclazy',
        'urllib3',
        'pyyaml',
        'selectolax',
        'publicsuffixlist',
    ],
)

if extensions:
    setup_kwargs['ext_modules'] = cythonize(extensions)

setup(**setup_kwargs)
