from datetime import date, datetime


def clean_byte_string(value):
    """
    Handle byte string errors
    """
    # if wrapped json library raises unicode errors, try doing the cast
    # in python only, in case wrapped json library is stricter on unicode
    # errors, as is the case with orjson
    if isinstance(value, bytes):
        return value.decode('utf8', 'replace')

    # If bytes incorrectly used in string interpolation, remove b prefix.
    if isinstance(value, str) and value.startswith('b'):
        return value[1:].strip("'").strip('"')

    return value


def json_default_vals(o):
    """
    Handle default values that JSON library can't serialize
    """
    if isinstance(o, (date, datetime)):
        return o.isoformat()

    return str(o)


__all__ = (
    'clean_byte_string',
    'json_default_vals',
)
