import yaml
try:
    from yaml.cyaml import (
        CDumper as Dumper,
        CLoader as Loader,
        CSafeDumper as SafeDumper,
        CSafeLoader as SafeLoader,
    )
except ImportError:
    from yaml import Dumper, Loader, SafeDumper, SafeLoader


def yaml_dump(data, stream=None, **kwargs):
    """
    Wrapper function for dumping python values to yaml,
    using C libraries for speed, if available.
    """
    return yaml.dump(data, stream, Dumper=Dumper, **kwargs)


def yaml_load(data):
    """
    Wrapper function for loading python values from yaml,
    using C libraries for speed, if available.
    """
    return yaml.load(data, Loader=Loader)


def yaml_safe_dump(data, stream=None, **kwargs):
    """
    Wrapper function for safe dumping python values to yaml,
    using C libraries for speed, if available.
    """
    return yaml.dump(data, stream, Dumper=SafeDumper, **kwargs)


def yaml_safe_load(data):
    """
    Wrapper function for safe loading python values from yaml,
    using C libraries for speed, if available.
    """
    return yaml.load(data, Loader=SafeLoader)


__all__ = (
    'yaml_dump',
    'yaml_load',
    'yaml_safe_dump',
    'yaml_safe_load',
)
