import io
from unittest import TestCase

from lcconfig.configparser import (
    LCConfigParser,
    ConsoleSettingsConfig,
)

rebranded_false = """
[default_email]
host = smtp.themailserver.com
port = 587
use_tls = True
username = reports@themailserver.com
password = password
from_address = reports@themailserver.com

[rebranded_email]
host = smtp.theresellersemailserver.com
port = 587
use_tls = True
username = reports@theresellersemailserver.com
password = password
from_address = reports@theresellersemailserver.com

[BoxData]
console_name = DrawBridge
name = happyharry
project_name = DrawBridge Systems
subnet = b'127.0.1.0/24
cloud_server = False
adminurl = happyharry.theserver.com
support_email = support@themailserver.com
filter_name = Redwood
phone = (856) 974-5335
slogan = Network Traffic Control: Enable - Defend - Protect
rebranded = False
hostname = draw.bridge
alternate_ips = []
alternate_hosts = []
"""

rebranded_true = """
[default_email]
host = smtp.themailserver.com
port = 587
use_tls = True
username = reports@themailserver.com
password = password
from_address = reports@themailserver.com

[rebranded_email]
host = smtp.theresellersemailserver.com
port = 587
use_tls = True
username = reports@theresellersemailserver.com
password = password
from_address = reports@theresellersemailserver.com

[BoxData]
console_name = DrawBridge
name = happyharry
project_name = DrawBridge Systems
subnet = b'127.0.1.0/24
cloud_server = False
adminurl = happyharry.theserver.com
support_email = support@themailserver.com
filter_name = Redwood
phone = (856) 974-5335
slogan = Network Traffic Control: Enable - Defend - Protect
rebranded = True
hostname = draw.bridge
alternate_ips = []
alternate_hosts = []
"""


class TestLCConfigParser(TestCase):
    def test_getfloat(self):
        config = {
            'TheDict': {
                'port': 443,
                'host': 'thehost.net',
                'schema': 'https',
            }
        }

        class DictConfig(LCConfigParser):
            config_settings = config

        cfg = DictConfig().load()

        with self.assertRaises(ValueError):
            cfg.getfloat('port')

    def test_load_dict(self):
        config = {
            'TheDict': {
                'port': 443,
                'host': 'thehost.net',
                'schema': 'https',
            }
        }

        cfg = LCConfigParser()
        cfg.config_settings = config
        cfg.load()

        self.assertTrue(cfg.has_section('TheDict'))
        self.assertDictEqual(config['TheDict'], cfg.as_typed_dict('TheDict'))

    def test_default_email_section(self):
        ccs = ConsoleSettingsConfig()
        ccs.config_settings = io.StringIO(rebranded_false)
        ccs.load()
        self.assertEqual(ccs.email_section(), 'default_email')

    def test_rebranded_email_section(self):
        ccs = ConsoleSettingsConfig()
        ccs.config_settings = io.StringIO(rebranded_true)
        ccs.load()
        self.assertEqual(ccs.email_section(), 'rebranded_email')
