from system_env.environment import setup_portal_environment
import os

try:
    setup_portal_environment()
    CONF_DIR = os.getenv('CONF_DIR')
except NotImplementedError:
    CONF_DIR = '/etc/compass'

ENCRYPT_KEYS = frozenset((
    'access_key',
    'access_token',
    'api_key',
    'auth_token',
    'bindpw',
    'client_secret',
    'chacha',
    'credentials',
    'endpoint',
    'fernet',
    'key',
    'password',
    'pw',
    'pwd',
    'refresh_token',
    'secret',
    'secret_key',
    'session_token',
    'token',
))

__all__ = (
    'CONF_DIR',
    'ENCRYPT_KEYS',
)
