from drf_spectacular.utils import extend_schema, extend_schema_view
from console_base.api.viewsets import LCModelViewSet

from lc_celery_beat.models import (
    ClockedSchedule,
    CrontabSchedule,
    IntervalSchedule,
    SolarSchedule,
    PeriodicTask,
)
from .filters import (
    ClockedScheduleFilter,
    CrontabScheduleFilter,
    IntervalScheduleFilter,
    SolarScheduleFilter,
    PeriodicTaskFilter,
)
from .serializers import (
    ClockedScheduleSerializer,
    ClockedScheduleDataTables,
    CrontabScheduleSerializer,
    CrontabScheduleDataTables,
    IntervalScheduleSerializer,
    IntervalScheduleDataTables,
    SolarScheduleSerializer,
    SolarScheduleDataTables,
    PeriodicTaskSerializer,
    PeriodicTaskDataTables,
)


# ---------------------------------------------------------------------------
@extend_schema_view(
    list=extend_schema(summary='List Clocked Schedules'),
    retrieve=extend_schema(summary='Get a Clocked Schedule'),
    create=extend_schema(summary='Create a Clocked Schedule'),
    update=extend_schema(summary='Update a Clocked Schedule'),
    partial_update=extend_schema(summary='Partially Update a Clocked Schedule'),
    destroy=extend_schema(summary='Delete a Clocked Schedule'),
)
class ClockedScheduleViewSet(LCModelViewSet):
    queryset = ClockedSchedule.objects
    serializer_class = ClockedScheduleSerializer
    datatables_serializer = ClockedScheduleDataTables
    filterset_class = ClockedScheduleFilter


# ---------------------------------------------------------------------------
@extend_schema_view(
    list=extend_schema(summary='List Crontab Schedules'),
    retrieve=extend_schema(summary='Get a Crontab Schedule'),
    create=extend_schema(summary='Create a Crontab Schedule'),
    update=extend_schema(summary='Update a Crontab Schedule'),
    partial_update=extend_schema(summary='Partially Update a Crontab Schedule'),
    destroy=extend_schema(summary='Delete a Crontab Schedule'),
)
class CrontabScheduleViewSet(LCModelViewSet):
    queryset = CrontabSchedule.objects
    serializer_class = CrontabScheduleSerializer
    datatables_serializer = CrontabScheduleDataTables
    filterset_class = CrontabScheduleFilter


# ---------------------------------------------------------------------------
@extend_schema_view(
    list=extend_schema(summary='List Interval Schedules'),
    retrieve=extend_schema(summary='Get a Interval Schedule'),
    create=extend_schema(summary='Create a Interval Schedule'),
    update=extend_schema(summary='Update a Interval Schedule'),
    partial_update=extend_schema(summary='Partially Update a Interval Schedule'),
    destroy=extend_schema(summary='Delete a Interval Schedule'),
)
class IntervalScheduleViewSet(LCModelViewSet):
    queryset = IntervalSchedule.objects
    serializer_class = IntervalScheduleSerializer
    datatables_serializer = IntervalScheduleDataTables
    filterset_class = IntervalScheduleFilter


# ---------------------------------------------------------------------------
@extend_schema_view(
    list=extend_schema(summary='List Solar Schedules'),
    retrieve=extend_schema(summary='Get a Solar Schedule'),
    create=extend_schema(summary='Create a Solar Schedule'),
    update=extend_schema(summary='Update a Solar Schedule'),
    partial_update=extend_schema(summary='Partially Update a Solar Schedule'),
    destroy=extend_schema(summary='Delete a Solar Schedule'),
)
class SolarScheduleViewSet(LCModelViewSet):
    queryset = SolarSchedule.objects
    serializer_class = SolarScheduleSerializer
    datatables_serializer = SolarScheduleDataTables
    filterset_class = SolarScheduleFilter


# ---------------------------------------------------------------------------
@extend_schema_view(
    list=extend_schema(summary='List Periodic Tasks'),
    retrieve=extend_schema(summary='Get a Periodic Task'),
    create=extend_schema(summary='Create a Periodic Task'),
    update=extend_schema(summary='Update a Periodic Task'),
    partial_update=extend_schema(summary='Partially Update a Periodic Task'),
    destroy=extend_schema(summary='Delete a Periodic Task'),
)
class PeriodicTaskViewSet(LCModelViewSet):
    queryset = PeriodicTask.objects
    serializer_class = PeriodicTaskSerializer
    datatables_serializer = PeriodicTaskDataTables
    filterset_class = PeriodicTaskFilter


__all__ = (
    'ClockedScheduleViewSet',
    'CrontabScheduleViewSet',
    'IntervalScheduleViewSet',
    'SolarScheduleViewSet',
    'PeriodicTaskViewSet',
)
