from django_filters import rest_framework as filters

from console_base.filters import (
    DateFilter,
    NameFilter,
)

from lc_celery_beat.models import (
    ClockedSchedule,
    CrontabSchedule,
    IntervalSchedule,
    SolarSchedule,
    PeriodicTask,
)


# ---------------------------------------------------------------------------
class ClockedScheduleFilter(DateFilter):

    clocked_time = filters.IsoDateTimeFilter(field_name='clocked_time', lookup_expr='gte')

    class Meta(DateFilter.Meta):
        model = ClockedSchedule
        fields = DateFilter.Meta.fields + ('clocked_time',)


# ---------------------------------------------------------------------------
class CrontabScheduleFilter(DateFilter):

    minute = filters.CharFilter(field_name='minute', label='Minute Equals')
    hour = filters.CharFilter(field_name='hour', label='Hour Equals')
    day_of_week = filters.CharFilter(field_name='day_of_week', label='Day of Week Equals')
    day_of_month = filters.CharFilter(field_name='day_of_month', label='Day of Month Equals')
    month_of_year = filters.CharFilter(field_name='month_of_year', label='Month of Year Equals')

    class Meta(DateFilter.Meta):
        model = CrontabSchedule
        fields = DateFilter.Meta.fields + (
            'minute',
            'hour',
            'day_of_week',
            'day_of_month',
            'month_of_year',
        )


# ---------------------------------------------------------------------------
class IntervalScheduleFilter(DateFilter):

    period = filters.CharFilter(field_name='period', label='Period Equals')

    class Meta(DateFilter.Meta):
        model = IntervalSchedule
        fields = DateFilter.Meta.fields + ('period',)


# ---------------------------------------------------------------------------
class SolarScheduleFilter(DateFilter):

    event = filters.CharFilter(field_name='event', label='Event Equals')

    class Meta(DateFilter.Meta):
        model = SolarSchedule
        fields = DateFilter.Meta.fields + ('event',)


# ---------------------------------------------------------------------------
class PeriodicTaskFilter(NameFilter):

    class Meta(NameFilter.Meta):
        model = PeriodicTask


__all__ = (
    'ClockedScheduleFilter',
    'CrontabScheduleFilter',
    'IntervalScheduleFilter',
    'SolarScheduleFilter',
    'PeriodicTaskFilter',
)
