"""
Django settings for Test project.

Generated by 'django-admin startproject' using Django 1.9.1.

For more information on this file, see
https://docs.djangoproject.com/en/1.9/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.9/ref/settings/
"""
import os
import sys
import tempfile
from types import SimpleNamespace

CELERY_DEFAULT_EXCHANGE = 'testcelery'
CELERY_DEFAULT_ROUTING_KEY = 'testcelery'
CELERY_DEFAULT_QUEUE = 'testcelery'

CELERY_QUEUES = {'testcelery': {'binding_key': 'testcelery'}}

CELERY_ACCEPT_CONTENT = ['pickle', 'json']
CELERY_TASK_SERIALIZER = 'pickle'
CELERY_RESULT_SERIALIZER = 'pickle'

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

sys.path.insert(0, os.path.abspath(os.path.join(BASE_DIR, os.pardir)))

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.9/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'u($kbs9$irs0)436gbo9%!b&#zyd&70tx!n7!i&fl6qun@z1_l'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = []

# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'drf_spectacular',
    'lc_celery_beat',
    't.proj',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
]

ROOT_URLCONF = 't.proj.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 't.proj.wsgi.application'

# Database
# https://docs.djangoproject.com/en/1.9/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
        'OPTIONS': {
            'timeout': 1000,
        },
    }
}

# Password validation
# https://docs.djangoproject.com/en/1.9/ref/settings/#auth-password-validators

django_auth = 'django.contrib.auth.password_validation.'

AUTH_PASSWORD_VALIDATORS = []

# Internationalization
# https://docs.djangoproject.com/en/1.9/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.9/howto/static-files/

STATIC_URL = '/static/'
DJANGO_CELERY_BEAT_TZ_AWARE = True

TMP_DIR = tempfile.gettempdir()
DEFAULT_HOSTNAME = 'log.cabin'
SILENCED_SYSTEM_CHECKS = ['models.W042']

DRF_EXCLUDE_SUFFIX = '_exclude'
FIELD_DOCS_PATH = 'tests.field_docs'

APPENDED_TEXT_TEMPLATE = 'lcbootstrap4/prepended_appended_text.html'
PREPENDED_TEXT_TEMPLATE = 'lcbootstrap4/prepended_appended_text.html'
PREPENDED_APPENDED_TEXT_TEMPLATE = 'lcbootstrap4/prepended_appended_text.html'
BUTTON_PREPENDED_APPENDED_TEXT_TEMPLATE = 'lcbootstrap4/button_prepended_appended_text.html'
FIELD_TEMPLATE = 'lcbootstrap4/field.html'
INPUT_BUTTON_GROUP_TEMPLATE = 'lcbootstrap4/input_buttongroup.html'

WIZARD_HOLDER_TEMPLATE = 'layout/tab-wizard.html'
WIZARD_SIDE_TAB_HOLDER_TEMPLATE = 'layout/side-tab-wizard.html'

FK_NAME_FIELDS = {
    'company',
    'parent',
    'policy',
}

TEXT_NAME_FIELDS = {
    'name',
    'dir_name',
    'config_name',
}

HTTP_METHODS = {
    'GET',
    'POST',
    'PUT',
    'DELETE',
    'TRACE',
    'OPTIONS',
    'CONNECT',
    'PATCH',
    'HEAD',
    'PROPFIND',
    'PROPPATCH',
    'UNLINK',
    'CHECKIN',
    'CHECKOUT',
    'LIST',
}

# yapf: disable
STATUS_CODES = {
    100, 101, 102,
    200, 201, 202, 203, 204, 205, 206, 207, 208, 226,
    301, 302, 303, 304, 305, 307, 308,
    400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414,
    415, 416, 417, 418, 421, 422, 423, 424, 426, 428, 429, 431, 444, 451, 499,
    500, 501, 502, 503, 504, 505, 506, 507, 508, 510, 511, 599,
}
# yapf: enable

MAIN_UP_TARGET = '#content_panel'
MAIN_UP_FAIL_TARGET = '#content_panel'

DEFAULT_UP_ERROR_TEMPLATE = 'unpoly_modal_error.html'

# Default Templates for various Unpoly layers.
# Override on individual View attributes.
UNPOLY_MODAL_TEMPLATE = 'unpoly_modal_form.html'
UNPOLY_DRAWER_TEMPLATE = ''
UNPOLY_POPUP_TEMPLATE = ''
UNPOLY_COVER_TEMPLATE = ''
OPTIMIZED_SUCCESS_RESPONSE = 'optimized_success_response'

# Tenant fields that are found on models in this console
# (some consoles will only have "company")
TENANT_FIELDS = ('company', 'policy')

MESSAGES_TEMPLATE = 'messages.html'
FILTERED_DATA_VIEW_URL = 'frontend:filtered_ac'
FILTERED_DEPENDENT_FIELDS = {
    'company': 'company',
}

ICONS = SimpleNamespace(CID='fas fa-fingerprint',)
