# Generated by Django 3.2.6 on 2022-01-13 19:27

import console_base.models.fields
import console_deps.dirtyfields.dirtyfields
import django.core.validators
from django.db import migrations, models
import django.utils.timezone
import lc_celery_beat.models
import lc_celery_beat.validators
import sequential_uuids.generators
import timezone_field.fields
help_text = 'Canonical ID assigned to this record, locally or on external systems. ' \
            'Should not be changed, except to reconcile sync errors.'


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='ClockedSchedule',
            fields=[
                (
                    'cid',
                    console_base.models.fields.CanonicalIdField(
                        db_index=True,
                        default=sequential_uuids.generators.uuid_time_nextval,
                        help_text=help_text,
                        unique=True,
                    )
                ),
                (
                    'created',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                (
                    'modified',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                ('is_active', models.BooleanField(default=True)),
                (
                    'id',
                    console_base.models.fields.UUID6Field(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        editable=False,
                        primary_key=True,
                        serialize=False
                    )
                ),
                ('builtin', models.BooleanField(default=False)),
                (
                    'clocked_time',
                    models.DateTimeField(
                        help_text='Run the task at clocked time', verbose_name='Clock Time'
                    )
                ),
            ],
            options={
                'verbose_name': 'clocked',
                'verbose_name_plural': 'clocked',
                'ordering': ['clocked_time'],
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model
            ),
        ),
        migrations.CreateModel(
            name='CrontabSchedule',
            fields=[
                (
                    'cid',
                    console_base.models.fields.CanonicalIdField(
                        db_index=True,
                        default=sequential_uuids.generators.uuid_time_nextval,
                        unique=True,
                        help_text=help_text,
                    )
                ),
                (
                    'created',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                (
                    'modified',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                ('is_active', models.BooleanField(default=True)),
                (
                    'id',
                    console_base.models.fields.UUID6Field(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        editable=False,
                        primary_key=True,
                        serialize=False
                    )
                ),
                ('builtin', models.BooleanField(default=False)),
                (
                    'minute',
                    models.CharField(
                        default='*',
                        help_text='Cron Minutes to Run. Use "*" for "all". (Example: "0,30")',
                        max_length=240,
                        validators=[lc_celery_beat.validators.minute_validator],
                        verbose_name='Minute(s)'
                    )
                ),
                (
                    'hour',
                    models.CharField(
                        default='*',
                        help_text='Cron Hours to Run. Use "*" for "all". (Example: "8,20")',
                        max_length=96,
                        validators=[lc_celery_beat.validators.hour_validator],
                        verbose_name='Hour(s)'
                    )
                ),
                (
                    'day_of_week',
                    models.CharField(
                        default='*',
                        help_text=
                        'Cron Days Of The Week to Run. Use "*" for "all". (Example: "0,5")',
                        max_length=64,
                        validators=[lc_celery_beat.validators.day_of_week_validator],
                        verbose_name='Day(s) Of The Week'
                    )
                ),
                (
                    'day_of_month',
                    models.CharField(
                        default='*',
                        help_text=
                        'Cron Days Of The Month to Run. Use "*" for "all". (Example: "1,15")',
                        max_length=124,
                        validators=[lc_celery_beat.validators.day_of_month_validator],
                        verbose_name='Day(s) Of The Month'
                    )
                ),
                (
                    'month_of_year',
                    models.CharField(
                        default='*',
                        help_text=
                        'Cron Months (1-12) Of The Year to Run. Use "*" for "all". (Example: "1,12")',
                        max_length=64,
                        validators=[lc_celery_beat.validators.month_of_year_validator],
                        verbose_name='Month(s) Of The Year'
                    )
                ),
                (
                    'timezone',
                    timezone_field.fields.TimeZoneField(
                        default=lc_celery_beat.models.crontab_schedule_celery_timezone,
                        help_text='Timezone to Run the Cron Schedule on. Default is UTC.',
                        verbose_name='Cron Timezone'
                    )
                ),
            ],
            options={
                'verbose_name': 'crontab',
                'verbose_name_plural': 'crontabs',
                'ordering': [
                    'month_of_year', 'day_of_month', 'day_of_week', 'hour', 'minute', 'timezone'
                ],
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model
            ),
        ),
        migrations.CreateModel(
            name='IntervalSchedule',
            fields=[
                (
                    'cid',
                    console_base.models.fields.CanonicalIdField(
                        db_index=True,
                        default=sequential_uuids.generators.uuid_time_nextval,
                        unique=True,
                        help_text=help_text,
                    )
                ),
                (
                    'created',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                (
                    'modified',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                ('is_active', models.BooleanField(default=True)),
                (
                    'id',
                    console_base.models.fields.UUID6Field(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        editable=False,
                        primary_key=True,
                        serialize=False
                    )
                ),
                ('builtin', models.BooleanField(default=False)),
                (
                    'every',
                    models.IntegerField(
                        help_text='Number of interval periods to wait before running the task again',
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name='Number of Periods'
                    )
                ),
                (
                    'period',
                    models.CharField(
                        choices=[('days', 'Days'), ('hours', 'Hours'), ('minutes', 'Minutes'),
                                 ('seconds', 'Seconds'), ('microseconds', 'Microseconds')],
                        help_text='The type of period between task runs (Example: days)',
                        max_length=24,
                        verbose_name='Interval Period'
                    )
                ),
            ],
            options={
                'verbose_name': 'interval',
                'verbose_name_plural': 'intervals',
                'ordering': ['period', 'every'],
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model
            ),
        ),
        migrations.CreateModel(
            name='PeriodicTask',
            fields=[
                (
                    'cid',
                    console_base.models.fields.CanonicalIdField(
                        db_index=True,
                        default=sequential_uuids.generators.uuid_time_nextval,
                        unique=True,
                        help_text=help_text,
                    )
                ),
                (
                    'created',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                (
                    'modified',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                (
                    'id',
                    console_base.models.fields.UUID6Field(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        editable=False,
                        primary_key=True,
                        serialize=False
                    )
                ),
                ('builtin', models.BooleanField(default=False)),
                (
                    'name',
                    models.CharField(
                        help_text='Short Description For This Task',
                        max_length=200,
                        unique=True,
                        verbose_name='Name'
                    )
                ),
                (
                    'task',
                    models.CharField(
                        db_index=True,
                        help_text=
                        'The Name of the Celery Task that Should be Run.  (Example: "proj.tasks.import_contacts")',
                        max_length=200,
                        verbose_name='Task Name'
                    )
                ),
                ('schedule_object_id', models.UUIDField(db_index=True)),
                (
                    'args',
                    console_base.models.fields.LCJSONField(
                        blank=True,
                        default=list,
                        help_text=
                        'List of positional arguments that will be encoded to JSON.(Example: ["arg1", "arg2"])',
                        null=True,
                        verbose_name='Positional Arguments'
                    )
                ),
                (
                    'kwargs',
                    console_base.models.fields.LCJSONField(
                        blank=True,
                        default=dict,
                        help_text=
                        'Dict of keyword arguments that will be encoded to JSON.(Example: {"argument": "value"})',
                        null=True,
                        verbose_name='Keyword Arguments'
                    )
                ),
                (
                    'queue',
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text=
                        'Queue defined in CELERY_TASK_QUEUES. Leave None for default queuing.',
                        max_length=200,
                        null=True,
                        verbose_name='Queue Override'
                    )
                ),
                (
                    'exchange',
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text='Override Exchange for low-level AMQP routing',
                        max_length=200,
                        null=True,
                        verbose_name='Exchange'
                    )
                ),
                (
                    'routing_key',
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text='Override Routing Key for low-level AMQP routing',
                        max_length=200,
                        null=True,
                        verbose_name='Routing Key'
                    )
                ),
                (
                    'headers',
                    console_base.models.fields.LCJSONField(
                        blank=True,
                        default=dict,
                        help_text='Dict of message headers for the AMQP message.',
                        null=True,
                        verbose_name='AMQP Message Headers'
                    )
                ),
                (
                    'priority',
                    models.PositiveIntegerField(
                        blank=True,
                        default=None,
                        help_text=
                        'Priority Number between 0 and 255. Supported by: RabbitMQ, Redis (priority reversed, 0 is highest).',
                        null=True,
                        validators=[django.core.validators.MaxValueValidator(255)],
                        verbose_name='Priority'
                    )
                ),
                (
                    'expires',
                    models.DateTimeField(
                        blank=True,
                        help_text=
                        'Datetime after which the schedule will no longer trigger the task to run',
                        null=True,
                        verbose_name='Expires Datetime'
                    )
                ),
                (
                    'expire_seconds',
                    models.PositiveIntegerField(
                        blank=True,
                        help_text=
                        'Timedelta with seconds which the schedule will no longer trigger the task to run',
                        null=True,
                        verbose_name='Expires timedelta with seconds'
                    )
                ),
                (
                    'one_off',
                    models.BooleanField(
                        default=False,
                        help_text='If True, the schedule will only run the task a single time',
                        verbose_name='One-off Task'
                    )
                ),
                (
                    'start_time',
                    models.DateTimeField(
                        blank=True,
                        help_text=
                        'Datetime when the schedule should begin triggering the task to run',
                        null=True,
                        verbose_name='Start Datetime'
                    )
                ),
                (
                    'is_active',
                    models.BooleanField(
                        default=True,
                        help_text='Set to False to disable the schedule',
                        verbose_name='Enabled'
                    )
                ),
                (
                    'last_run_at',
                    models.DateTimeField(
                        blank=True,
                        editable=False,
                        help_text=
                        'Datetime that the schedule last triggered the task to run. Reset to None if is_active is set to False.',
                        null=True,
                        verbose_name='Last Run Datetime'
                    )
                ),
                (
                    'total_run_count',
                    models.PositiveIntegerField(
                        default=0,
                        editable=False,
                        help_text=
                        'Running count of how many times the schedule has triggered the task',
                        verbose_name='Total Run Count'
                    )
                ),
                (
                    'date_changed',
                    models.DateTimeField(
                        auto_now=True,
                        help_text='Datetime that this PeriodicTask was last modified',
                        verbose_name='Last Modified'
                    )
                ),
                (
                    'description',
                    models.TextField(
                        blank=True,
                        help_text='Detailed description about the details of this Periodic Task',
                        verbose_name='Description'
                    )
                ),
            ],
            options={
                'verbose_name': 'periodic task',
                'verbose_name_plural': 'periodic tasks',
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model
            ),
        ),
        migrations.CreateModel(
            name='PeriodicTasks',
            fields=[
                (
                    'cid',
                    console_base.models.fields.CanonicalIdField(
                        db_index=True,
                        default=sequential_uuids.generators.uuid_time_nextval,
                        unique=True,
                        help_text=help_text,
                    )
                ),
                (
                    'created',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                (
                    'modified',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                ('is_active', models.BooleanField(default=True)),
                (
                    'ident',
                    models.SmallIntegerField(
                        default=1, primary_key=True, serialize=False, unique=True
                    )
                ),
                ('last_update', models.DateTimeField()),
            ],
            options={
                'abstract': False,
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model
            ),
        ),
        migrations.CreateModel(
            name='SolarSchedule',
            fields=[
                (
                    'cid',
                    console_base.models.fields.CanonicalIdField(
                        db_index=True,
                        default=sequential_uuids.generators.uuid_time_nextval,
                        unique=True,
                        help_text=help_text,
                    )
                ),
                (
                    'created',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                (
                    'modified',
                    console_base.models.fields.LCDateTimeField(default=django.utils.timezone.now)
                ),
                ('is_active', models.BooleanField(default=True)),
                (
                    'id',
                    console_base.models.fields.UUID6Field(
                        default=sequential_uuids.generators.uuid_time_nextval,
                        editable=False,
                        primary_key=True,
                        serialize=False
                    )
                ),
                ('builtin', models.BooleanField(default=False)),
                (
                    'event',
                    models.CharField(
                        choices=[('dawn_astronomical', 'Astronomical dawn'),
                                 ('dawn_civil', 'Civil dawn'), ('dawn_nautical', 'Nautical dawn'),
                                 ('dusk_astronomical', 'Astronomical dusk'),
                                 ('dusk_civil', 'Civil dusk'), ('dusk_nautical', 'Nautical dusk'),
                                 ('solar_noon', 'Solar noon'), ('sunrise', 'Sunrise'),
                                 ('sunset', 'Sunset')],
                        help_text='The type of solar event when the job should run',
                        max_length=24,
                        verbose_name='Solar Event'
                    )
                ),
                (
                    'latitude',
                    models.DecimalField(
                        decimal_places=6,
                        help_text='Run the task when the event happens at this latitude',
                        max_digits=9,
                        validators=[
                            django.core.validators.MinValueValidator(-90),
                            django.core.validators.MaxValueValidator(90)
                        ],
                        verbose_name='Latitude'
                    )
                ),
                (
                    'longitude',
                    models.DecimalField(
                        decimal_places=6,
                        help_text='Run the task when the event happens at this longitude',
                        max_digits=9,
                        validators=[
                            django.core.validators.MinValueValidator(-180),
                            django.core.validators.MaxValueValidator(180)
                        ],
                        verbose_name='Longitude'
                    )
                ),
            ],
            options={
                'verbose_name': 'solar event',
                'verbose_name_plural': 'solar events',
                'ordering': ('event', 'latitude', 'longitude'),
            },
            bases=(
                console_base.models.mixins.FilterFields,
                console_deps.dirtyfields.dirtyfields.DirtyFieldsMixin, models.Model
            ),
        ),
        migrations.AddConstraint(
            model_name='solarschedule',
            constraint=models.UniqueConstraint(
                fields=('event', 'latitude', 'longitude'), name='solar_schedule_unique'
            ),
        ),
        migrations.AddField(
            model_name='periodictask',
            name='schedule_content_type',
            field=models.ForeignKey(
                limit_choices_to=models.Q(('app_label', 'lc_celery_beat'), (
                    'model__in',
                    ('crontabschedule', 'clockedschedule', 'intervalschedule', 'solarschedule')
                )),
                on_delete=django.db.models.deletion.CASCADE,
                to='contenttypes.contenttype'
            ),
        ),
        migrations.AddConstraint(
            model_name='intervalschedule',
            constraint=models.UniqueConstraint(
                fields=('every', 'period'), name='interval_schedule_unique'
            ),
        ),
        migrations.AddConstraint(
            model_name='crontabschedule',
            constraint=models.UniqueConstraint(
                fields=(
                    'minute', 'hour', 'day_of_week', 'day_of_month', 'month_of_year', 'timezone'
                ),
                name='crontab_schedule_unique'
            ),
        ),
        migrations.AddConstraint(
            model_name='clockedschedule',
            constraint=models.UniqueConstraint(
                fields=('clocked_time',), name='clocked_schedule_unique'
            ),
        ),
    ]
