from django import forms

from crispy_forms.layout import Layout, Field
from console_base.forms import (
    NameField,
    JSONFormField,
    JSONWidget,
    LCNullBooleanField,
)
from console_base.forms.crispy_forms import Tab, LCWizardHolder

from lc_celery_beat.models import (
    ClockedSchedule,
    CrontabSchedule,
    IntervalSchedule,
    SolarSchedule,
    PeriodicTask,
)
from console_base.forms import (
    LCModelFormBase,
    save_clear_buttons,
)


# ----------------------------------------------------------------------
class ClockedScheduleForm(LCModelFormBase):

    clocked_time = forms.DateTimeField()
    is_active = LCNullBooleanField(initial=True)

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        self.helper.layout = Layout(
            Field('clocked_time'),
            Field('is_active'),
            save_clear_buttons,
        )

    class Meta:
        model = ClockedSchedule
        fields = ('clocked_time',)


# ----------------------------------------------------------------------
class CrontabScheduleForm(LCModelFormBase):

    minute = forms.CharField(initial='*')
    hour = forms.CharField(initial='*')
    day_of_week = forms.CharField(initial='*')
    day_of_month = forms.CharField(initial='*')
    month_of_year = forms.CharField(initial='*')
    is_active = LCNullBooleanField(initial=True)

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        self.helper.layout = Layout(
            Field('minute'),
            Field('hour'),
            Field('day_of_week'),
            Field('day_of_month'),
            Field('month_of_year'),
            Field('is_active'),
            save_clear_buttons,
        )

    class Meta:
        model = CrontabSchedule
        fields = (
            'minute',
            'hour',
            'day_of_week',
            'day_of_month',
            'month_of_year',
        )


# ----------------------------------------------------------------------
class IntervalScheduleForm(LCModelFormBase):

    every = forms.DateTimeField()
    is_active = LCNullBooleanField(initial=True)

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        self.helper.layout = Layout(
            Field('every'),
            Field('period'),
            Field('is_active'),
            save_clear_buttons,
        )

    class Meta:
        model = IntervalSchedule
        fields = (
            'every',
            'period',
        )


# ----------------------------------------------------------------------
class SolarScheduleForm(LCModelFormBase):

    latitude = forms.DecimalField(max_digits=9, decimal_places=6)
    longitude = forms.DecimalField(max_digits=9, decimal_places=6)
    is_active = LCNullBooleanField(initial=True)

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)

        self.helper.layout = Layout(
            Field('event'),
            Field('latitude'),
            Field('longitude'),
            save_clear_buttons,
        )

    class Meta:
        model = SolarSchedule
        fields = (
            'event',
            'latitude',
            'longitude',
        )


# ----------------------------------------------------------------------
class PeriodicTaskForm(LCModelFormBase):

    name = forms.CharField()
    task = forms.CharField()
    args = JSONFormField(required=False, widget=JSONWidget)
    kwargs = JSONFormField(required=False, widget=JSONWidget)
    queue = forms.CharField(required=False)
    priority = forms.IntegerField(required=False)
    expires = forms.DateTimeField(required=False)
    one_off = LCNullBooleanField(initial=False)
    is_active = LCNullBooleanField(initial=True)
    description = forms.CharField(required=False, widget=forms.TextInput)

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.helper.form_id = 'console_wizard'
        self.helper.layout = Layout(
            LCWizardHolder(
                Tab(
                    'Task',
                    NameField('name', autofocus='autofocus'),
                    Field('description'),
                    Field('task'),
                    Field('args'),
                    Field('kwargs'),
                ),
                Tab(
                    'Status',
                    Field('priority'),
                    Field('expires'),
                    Field('one_off'),
                    Field('is_active'),
                    Field('queue'),
                ),
            ),
        )

    class Meta:
        model = PeriodicTask
        fields = (
            'name',
            'task',
            'args',
            'kwargs',
            'queue',
            'priority',
            'expires',
            'one_off',
            'is_active',
            'description',
        )
