class TaskFailedExit(Exception):
    """
    Raised when a task fails to complete but shouldn't be retried.
    """

    def __init__(self, *args, **kwargs):
        """
        Add original exception objects and Response object
        if this exception was raised during network calls.
        """
        self.response = kwargs.pop('response', None)
        self.exception = kwargs.pop('exception', None)
        super().__init__(*args, **kwargs)
