from timezone_field.rest_framework import TimeZoneSerializerField
from console_base.api.serializers import (
    LCModelSerializer,
    LCHyperlinkedIdentityField,
)

from lc_celery_beat.models import (
    ClockedSchedule,
    CrontabSchedule,
    IntervalSchedule,
    SolarSchedule,
    PeriodicTask,
)

BASE_READ_ONLY_FIELDS = (
    'pk',
    'url',
    'created',
    'modified',
)


# ---------------------------------------------------------------------------
class ClockedScheduleSerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-clockedschedule-detail')

    class Meta:
        model = ClockedSchedule
        fields = (
            'pk',
            'url',
            'created',
            'modified',
            'cid',
            'is_active',
            'builtin',
            'clocked_time',
        )
        read_only_fields = BASE_READ_ONLY_FIELDS


# ---------------------------------------------------------------------------
class ClockedScheduleDataTables(ClockedScheduleSerializer):

    class Meta(ClockedScheduleSerializer.Meta):
        fields = ClockedScheduleSerializer.Meta.fields + ('row_pk',)


# ---------------------------------------------------------------------------
class CrontabScheduleSerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-crontabschedule-detail')
    timezone = TimeZoneSerializerField()

    class Meta:
        model = CrontabSchedule
        fields = (
            'pk',
            'url',
            'created',
            'modified',
            'cid',
            'is_active',
            'builtin',
            'minute',
            'hour',
            'day_of_week',
            'day_of_month',
            'month_of_year',
            'timezone',
        )
        read_only_fields = BASE_READ_ONLY_FIELDS


# ---------------------------------------------------------------------------
class CrontabScheduleDataTables(CrontabScheduleSerializer):

    class Meta(CrontabScheduleSerializer.Meta):
        fields = CrontabScheduleSerializer.Meta.fields + ('row_pk',)


# ---------------------------------------------------------------------------
class IntervalScheduleSerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-intervalschedule-detail')

    class Meta:
        model = IntervalSchedule
        fields = (
            'pk',
            'url',
            'created',
            'modified',
            'cid',
            'is_active',
            'builtin',
            'every',
            'period',
        )
        read_only_fields = BASE_READ_ONLY_FIELDS


# ---------------------------------------------------------------------------
class IntervalScheduleDataTables(IntervalScheduleSerializer):

    class Meta(IntervalScheduleSerializer.Meta):
        fields = IntervalScheduleSerializer.Meta.fields + ('row_pk',)


# ---------------------------------------------------------------------------
class SolarScheduleSerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-solarschedule-detail')

    class Meta:
        model = SolarSchedule
        fields = (
            'pk',
            'url',
            'created',
            'modified',
            'cid',
            'is_active',
            'builtin',
            'event',
            'latitude',
            'longitude',
        )
        read_only_fields = BASE_READ_ONLY_FIELDS


# ---------------------------------------------------------------------------
class SolarScheduleDataTables(SolarScheduleSerializer):

    class Meta(SolarScheduleSerializer.Meta):
        fields = SolarScheduleSerializer.Meta.fields + ('row_pk',)


# ---------------------------------------------------------------------------
class PeriodicTaskSerializer(LCModelSerializer):

    url = LCHyperlinkedIdentityField(view_name='api-periodictask-detail')

    class Meta:
        model = PeriodicTask
        fields = (
            'pk',
            'url',
            'created',
            'modified',
            'cid',
            'is_active',
            'name',
            'task',
            'args',
            'kwargs',
            'queue',
            'priority',
            'expires',
            'expire_seconds',
            'one_off',
            'start_time',
            'description',
            'schedule_object_id',
        )
        read_only_fields = BASE_READ_ONLY_FIELDS + (
            'pk',
            'url',
            'last_run_at',
            'total_run_count',
        )


# ---------------------------------------------------------------------------
class PeriodicTaskDataTables(PeriodicTaskSerializer):

    class Meta(PeriodicTaskSerializer.Meta):
        fields = (
            'pk',
            'row_pk',
            'url',
            'created',
            'modified',
            'cid',
            'is_active',
            'name',
            'task',
        )


__all__ = (
    'ClockedScheduleSerializer',
    'ClockedScheduleDataTables',
    'CrontabScheduleSerializer',
    'CrontabScheduleDataTables',
    'IntervalScheduleSerializer',
    'IntervalScheduleDataTables',
    'SolarScheduleSerializer',
    'SolarScheduleDataTables',
    'PeriodicTaskSerializer',
    'PeriodicTaskDataTables',
)
