import pytest
from django.test import TestCase

from lc_celery_beat.admin import PeriodicTaskAdmin
from lc_celery_beat.models import \
    DAYS, \
    PeriodicTask, \
    IntervalSchedule


@pytest.mark.django_db()
class ActionsTests(TestCase):

    @classmethod
    def setUpTestData(cls):
        super().setUpTestData()
        cls.interval_schedule = IntervalSchedule.objects.create(every=10, period=DAYS)

    def test_toggle_action(self):
        PeriodicTask.objects.create(
            name='name1', task='task1', is_active=False, schedule=self.interval_schedule
        )
        PeriodicTask.objects.create(
            name='name2', task='task2', is_active=True, schedule=self.interval_schedule
        )
        PeriodicTask.objects.create(
            name='name3', task='task3', is_active=False, schedule=self.interval_schedule
        )

        qs = PeriodicTask.objects.all()
        PeriodicTaskAdmin(PeriodicTask, None)._toggle_tasks_activity(qs)

        e1 = PeriodicTask.objects.get(name='name1', task='task1').is_active
        e2 = PeriodicTask.objects.get(name='name2', task='task2').is_active
        e3 = PeriodicTask.objects.get(name='name3', task='task3').is_active
        self.assertTrue(e1)
        self.assertFalse(e2)
        self.assertTrue(e3)

    def test_toggle_action_all_enabled(self):
        PeriodicTask.objects.create(
            name='name1',
            task='task1',
            is_active=True,
            schedule=self.interval_schedule,
        )
        PeriodicTask.objects.create(
            name='name2',
            task='task2',
            is_active=True,
            schedule=self.interval_schedule,
        )
        PeriodicTask.objects.create(
            name='name3',
            task='task3',
            is_active=True,
            schedule=self.interval_schedule,
        )

        qs = PeriodicTask.objects.all()
        PeriodicTaskAdmin(PeriodicTask, None)._toggle_tasks_activity(qs)

        e1 = PeriodicTask.objects.get(name='name1', task='task1').is_active
        e2 = PeriodicTask.objects.get(name='name2', task='task2').is_active
        e3 = PeriodicTask.objects.get(name='name3', task='task3').is_active
        self.assertFalse(e1)
        self.assertFalse(e2)
        self.assertFalse(e3)

    def test_toggle_action_all_disabled(self):

        PeriodicTask.objects.create(
            name='name1',
            task='task1',
            is_active=False,
            schedule=self.interval_schedule,
        )
        PeriodicTask.objects.create(
            name='name2',
            task='task2',
            is_active=False,
            schedule=self.interval_schedule,
        )
        PeriodicTask.objects.create(
            name='name3',
            task='task3',
            is_active=False,
            schedule=self.interval_schedule,
        )

        qs = PeriodicTask.objects.all()
        PeriodicTaskAdmin(PeriodicTask, None)._toggle_tasks_activity(qs)

        e1 = PeriodicTask.objects.get(name='name1', task='task1').is_active
        e2 = PeriodicTask.objects.get(name='name2', task='task2').is_active
        e3 = PeriodicTask.objects.get(name='name3', task='task3').is_active
        self.assertTrue(e1)
        self.assertTrue(e2)
        self.assertTrue(e3)
