"""Model managers."""
from django.contrib.contenttypes.models import ContentType
from django.db import models
from console_base.managers import LCBaseQuerySet


def set_schedule_kwargs(**kwargs):
    """Lookup Generic values from schedule keyword if it was provided."""
    schedule = kwargs.pop('schedule', None)
    if schedule:
        try:
            kwargs['schedule_object_id'] = schedule.id
            content_type = ContentType.objects.get_for_model(schedule)
            kwargs['schedule_content_type'] = content_type
        except AttributeError:
            raise ValueError("'schedule' value must be a Model Object!")

    return kwargs


class PeriodicTaskManager(models.Manager.from_queryset(LCBaseQuerySet)):
    """Manager for PeriodicTask model."""

    def create(self, **kwargs):
        return super().create(**set_schedule_kwargs(**kwargs))

    def get_or_create(self, defaults=None, **kwargs):
        if defaults:
            defaults = set_schedule_kwargs(**defaults)
        return super().get_or_create(defaults=defaults, **set_schedule_kwargs(**kwargs))

    def update_or_create(self, defaults=None, **kwargs):
        if defaults:
            defaults = set_schedule_kwargs(**defaults)
        return super().update_or_create(defaults=defaults, **set_schedule_kwargs(**kwargs))

    def active(self):
        return super().active().prefetch_related('schedule_object')
