from sanic import Sanic
from .core.request import IvyLinkRequest
from ivylink.images import HashDatabase, ImageIndex
from .images.urls import images_bp
from ..settings import LOGGING

app = Sanic("ivylink_web", request_class=IvyLinkRequest, log_config=LOGGING)

app.blueprint(images_bp)
app.ctx.hash_database = HashDatabase()
app.ctx.image_index = ImageIndex(hash_database=app.ctx.hash_database)


def serve():
    app.run(
        host='127.0.0.1',
        port=10009,
        dev=False,
        debug=False,
        access_log=False,
        fast=True,
    )


if __name__ == '__main__':

    serve()
