from io import BytesIO
from PIL import Image
import pybase64
from sanic.exceptions import InvalidUsage
from sanic.views import HTTPMethodView


class IvyLinkImageView(HTTPMethodView):

    def load_image(self, data):
        """
        Decode image from POST body and return Image object.
        """
        try:

            image = Image.open(BytesIO(pybase64.b64decode(data['image'])))
            if image.format == 'PNG' and image.mode != 'RGBA':
                return image.convert('RGBA')

            return image.convert('RGB')

        except Exception as e:
            raise InvalidUsage(str(e))


__all__ = [
    'IvyLinkImageView',
]
