from typing import NamedTuple
import numpy as np


class DihedralHash(NamedTuple):
    """
    Return type of dihedral hashing operation.
    """
    r0: np.ndarray
    r90: np.ndarray
    r180: np.ndarray
    r270: np.ndarray
    fv: np.ndarray
    fh: np.ndarray
    r90fv: np.ndarray
    r90fh: np.ndarray


class FastDihedralHash(NamedTuple):
    """
    Check only standard orientation and flipped horizontal
    """
    r0: np.ndarray
    fh: np.ndarray


class IsometricHash(NamedTuple):
    """
    Return type of dihedral hashing operation.
    """
    r0: str
    r90: str
    r180: str
    r270: str
    fv: str
    fh: str
    r90fv: str
    r90fh: str


class SearchResults(NamedTuple):
    entry: int
    distance: float


__all__ = (
    'DihedralHash',
    'FastDihedralHash',
    'IsometricHash',
    'SearchResults',
)
