import sys

ALLOW_ANNOY_INDEX_FILE = '/etc/redwood/categories/whitewood/image_hashes.ann'
ALLOW_HASH_DATABASE_FILE = '/etc/redwood/categories/whitewood/image_hashes.yml'

BLOCK_ANNOY_INDEX_FILE = '/etc/redwood/categories/inappropriate/image_hashes.ann'
BLOCK_HASH_DATABASE_FILE = '/etc/redwood/categories/inappropriate/image_hashes.yml'

LOGGING = dict(
    version=1,
    disable_existing_loggers=False,
    loggers={
        "sanic.root": {
            "level": "INFO",
            "handlers": ["file"],
        },
        "sanic.error": {
            "level": "INFO",
            "handlers": ["error_file"],
            "propagate": True,
            "qualname": "sanic.error",
        },
        "sanic.access": {
            "level": "INFO",
            "handlers": ["access_file"],
            "propagate": True,
            "qualname": "sanic.access",
        },
    },
    handlers={
        "console": {
            "class": "logging.StreamHandler",
            "formatter": "generic",
            "stream": sys.stdout,
        },
        "error_file": {
            'class': 'logging.FileHandler',
            'filename': '/var/log/ivylink/ivylink-error.log',
            "formatter": "generic",
        },
        "access_file": {
            'class': 'logging.FileHandler',
            'filename': '/var/log/ivylink/ivylink-access.log',
            "formatter": "access",
        },
        'file': {
            'level': 'INFO',
            'class': 'logging.FileHandler',
            'filename': '/var/log/ivylink/ivylink.log',
            "formatter": "generic",
        },
    },
    formatters={
        "generic": {
            "format": "%(asctime)s [%(process)d] [%(levelname)s] %(message)s",
            "datefmt": "[%Y-%m-%d %H:%M:%S %z]",
            "class": "logging.Formatter",
        },
        "access": {
            "format": "%(asctime)s - (%(name)s)[%(levelname)s][%(host)s]: " +
            "%(request)s %(message)s %(status)d %(byte)d",
            "datefmt": "[%Y-%m-%d %H:%M:%S %z]",
            "class": "logging.Formatter",
        },
    },
)
