HTML_TAG_SET = frozenset([
    'a',
    'abbr',
    'address',
    'area',
    'article',
    'aside',
    'audio',
    'base',
    'bdi',
    'blockquote',
    'br',
    'button',
    'canvas',
    'caption',
    'cite',
    'code',
    'col',
    'colgroup',
    'data',
    'datalist',
    'details',
    'dialog',
    'div',
    'em',
    'embed',
    'fieldset',
    'figcaption',
    'figure',
    'footer',
    'form',
    'h1',
    'h2',
    'h3',
    'h4',
    'h5',
    'h6',
    'header',
    'i',
    'img',
    'input',
    'label',
    'legend',
    'li',
    'main',
    'map',
    'mark',
    'menu',
    'menuitem',
    'meta',
    'nav',
    'object',
    'ol',
    'optgroup',
    'option',
    'p',
    'param',
    'picture',
    'pre',
    'progress',
    'rp',
    'rt',
    'ruby',
    'section',
    'small',
    'span',
    'strong',
    'summary',
    'svg',
    'table',
    'tbody',
    'td',
    'th',
    'tr',
    'time',
    'ul',
    'video',
    'wbr',
])

HTML_TAGS = tuple([t for t in HTML_TAG_SET if len(t) > 1])


def validate_selector(selector: str):
    """
    Check if selector is a valid html tag or CSS ID or Class.
    """
    for sv in (selector.lower(), f'{selector}#', f'{selector}.'):
        if sv.startswith(('#', '.')) or sv in HTML_TAG_SET or sv.startswith(HTML_TAGS):
            return

    raise SystemExit(
        f'\n{selector!r} does not appear to be an HTML tag!\n\n'
        f'Do you want a CSS ID "#{selector}" or CSS Class ".{selector}"?\n'
    )


__all__ = (
    'HTML_TAG_SET',
    'HTML_TAGS',
    'validate_selector',
)
