from lchttp.htmlparsing import HTMLParser
from typing import List
from selectolax.parser import Node
from .tags import HTML_TAGS, HTML_TAG_SET


class IvyHTMLParser(HTMLParser):

    def images_from_css(self, selector: str) -> List[Node]:
        """
        Extract all child `img` elements from the specified selector.
        """
        try:
            images = self.soup.css(f'{selector} img')
        except ValueError as e:
            print(e)
            return []

        if not images and selector.lower() in HTML_TAGS:
            print(
                f'\nNo child img tags found in Selector "{selector} img" - '
                f'checking for img tags with {selector!r} selector.'
            )
            images = self.soup.css(selector)

        if not images:
            print(f'\nNo images found! Confirm that {selector!r} is a valid CSS selector.\n')

        return images


__all__ = [
    'IvyHTMLParser',
]
