import logging
import signal

logger = logging.getLogger('ivylink')


def run():
    """
    Run IvyLink process.
    """

    class ProcessExit(Exception):
        """
        Custom exception which is used to trigger the clean exit
        of all running threads and the main program.
        """
        pass

    def service_shutdown(signum, frame):
        logger.info('Caught signal %d' % signum)
        raise ProcessExit

    signal.signal(signal.SIGTERM, service_shutdown)
    signal.signal(signal.SIGINT, service_shutdown)
    signal.signal(signal.SIGHUP, service_shutdown)

    print('Running IvyLink')


if __name__ == "__main__":
    run()
