from datetime import datetime, timezone


def localize_time(date: str):
    """
    Convert datetime string to local time
    """
    for fmt in (
            '%Y-%m-%d %H:%M:%S',
            '%Y-%m-%d %H:%M:%S.%f',
            '%Y-%m-%d %H:%M',
            '%Y-%m-%d',
    ):
        try:
            return datetime.strptime(date, fmt).replace(tzinfo=timezone.utc).astimezone()
        except ValueError:
            continue
        except TypeError:
            return date


__all__ = [
    'localize_time',
]
