"""
hedge Test Cases. Run entire suite by:

python3 -m unittest

Run individual test class by:

python3 -m unittest hedge.tests.test_<name>
"""
from pathlib import Path
import unittest
from ..actors.shadow import ShadowDatabase
from ..installation import shadow_setup
from ..settings import DATABASE_PATH


shadow_file = [
    {'sp_namp': 'root', 'sp_pwdp': 'b081a64c43b8bd5fed302ac70e7d1b301b38d73b059296f9b80c2fd35026f91c', 'sp_lstchg': 18473, 'sp_min': 0, 'sp_max': 99999, 'sp_warn': 7, 'sp_inact': -1, 'sp_expire': -1, 'sp_flag': -1},
    {'sp_namp': 'winadmin', 'sp_pwdp': '806af4cec6d97cc82725246dc103e10e51cbb6e8b3343261f0bf57b03bb6634b', 'sp_lstchg': -1, 'sp_min': -1, 'sp_max': -1, 'sp_warn': -1, 'sp_inact': -1, 'sp_expire': -1, 'sp_flag': 0},
    {'sp_namp': 'david', 'sp_pwdp': '8520fc5734fb3acb205732e5856b5a0089f797c3695573ef8c980bc04327d460', 'sp_lstchg': -1, 'sp_min': -1, 'sp_max': -1, 'sp_warn': -1, 'sp_inact': -1, 'sp_expire': -1, 'sp_flag': 0},
    {'sp_namp': 'toughbook-cf54', 'sp_pwdp': '8520fc5734fb3acb205732e5856b5a0089f797c3695573ef8c980bc04327d460', 'sp_lstchg': -1, 'sp_min': -1, 'sp_max': -1, 'sp_warn': -1, 'sp_inact': -1, 'sp_expire': -1, 'sp_flag': 0},
]
new_entry = [
    {'sp_namp': 'toughpad-x1', 'sp_pwdp': '8520fc5734fb3acb205732e5856b5a0089f797c3695573ef8c980bc04327d460', 'sp_lstchg': -1, 'sp_min': -1, 'sp_max': -1, 'sp_warn': -1, 'sp_inact': -1, 'sp_expire': -1, 'sp_flag': 0},
]


class TestShadowDatabase(unittest.TestCase):

    @classmethod
    def setUpClass(cls) -> None:
        shadow_setup()

    @classmethod
    def tearDownClass(cls) -> None:
        Path(DATABASE_PATH).unlink(missing_ok=True)

    def test_shadow_database(self):
        database = ShadowDatabase()
        database.add_passwords(shadow_file)

        self.assertSetEqual(
            {u['sp_namp'] for u in database.users()},
            {u['sp_namp'] for u in shadow_file},
            msg='database must contain all shadow file users'
        )

        # All additions should be unreported
        unreported_changes = database.unreported_changes()
        self.assertSetEqual(
            {u['sp_namp'] for u in unreported_changes},
            {u['sp_namp'] for u in shadow_file},
            msg='database must contain all shadow file users'
        )

        # Single change should succeed
        entry = unreported_changes.pop()
        database.mark_reported([entry['id']])

        # Multiple changes should succeed
        database.mark_reported([pwd['id'] for pwd in unreported_changes])

        self.assertListEqual(database.unreported_changes(), [])


if __name__ == '__main__':
    unittest.main()
